﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;


/* using threads for the first time */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }


 
        Thread t = null;

        /* this is the starting method of the thread 
           It starts executing, in an asynchronous manner,
           immediately after a Thread.Start() call */
        void ThreadProc()
        {
            Thread.Sleep(5000);         // go to sleep for 5 seconds 
        }


        private void button1_Click(object sender, EventArgs e)
        {
            if ((t == null) || (!t.IsAlive))    // IsAlive is true when the thread has been started and has not terminated         
            {
                t = new Thread(ThreadProc);     // create a thread
                t.Start();                      // and start it

                MessageBox.Show("Main thread continues execution. Thread.Start() does not block the execution of the calling thread. Thread.Start() returns immediately");
            }
 
        }

        /* When the main form closes the application terminates.
           
          CAUTION:  Attempting to terminate an application while any of its foreground threads 
                    is still running hangs the application.
           
           FormClosing() event handler is called just before a form close.
           Assigning e.Cancel to true, cancels the form closing procedure */
        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = (t != null) && (t.IsAlive);

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }
    }
}
